package net.kldp.logviewer;

import net.kldp.logviewer.define.LogDefine;
import net.kldp.logviewer.model.LogViewerEntry;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddOrModifyLogView extends Dialog {
	public static final String ID = "net.kldp.logviewer.AddOrModifyLogView"; // TODO Needs to be whatever is mentioned in plugin.xml
	
//	long	seq		= 0l;
	String _groupNm = "";
	LogViewerEntry _entry = null;

	private Composite sShell = null;
	private Shell parentShell = null;

	//-------------------
	private Label lblGroup = null;

	private Label lblName = null;

	private Text txtNm = null;

	private Combo cbMethod = null;

	private Label lblMethod = null;

	private Label lblFileNm = null;

	private Text txtFileNm = null;

	private Label lblDelay = null;

	private Text txtDelay = null;

	private Label lblDelayNm = null;
	
	private CLabel cLabel = null;
	private Text txtGroupNm = null;
	private Group grpFont = null;
	private Label lblFont = null;
	private Combo cbFont = null;	
	private Combo cbFontSize = null;
	private Group grpFTP = null;
	private Label lblIP = null;
	private Label lblID = null;
	private Label lblPass = null;
	private Text txtIP = null;
	private Text txtPort = null;
	private Text txtId = null;
	private Text txtPass = null;
	private Button chkPasMode = null;	
	private Button btnFontCol = null;
	private Button btnBackCol = null;
	private CLabel lbBackCol = null;
	private CLabel lbFontCol = null;
	private StyledText testStyledTxt = null;
	
	private Text txtLineMit = null;
	private Label lblLineLimit = null;
	private Group grpAlarm = null;
	private Text txtAlarm = null;
	private Combo cbAlarmType = null;
	private CLabel lbAlarm = null;
	private Button btnAlarmCol = null;
	//----------------------------------------------------------------------------------------
	
	public AddOrModifyLogView(Shell parentShell, String groupNm, LogViewerEntry entry) {
		super(parentShell);
//		parentShell.setText("ȯ ");
		
		this.parentShell = parentShell;
		_groupNm = groupNm;
		_entry = entry;
	}	
	
	
	protected Control createDialogArea(Composite parent) {
		
		// TODO Auto-generated method stub		
		sShell = new Composite(parent, SWT.NONE);				
		//-------------------------------------------------------------------------------------
		//sShell.setText("α");
		sShell.setLayout(null);
//		sShell.setSize(new Point(466, 491));
		sShell.setSize(new Point(379, 408));
		
		cLabel = new CLabel(sShell, SWT.SHADOW_OUT);
		cLabel.setText("ȯ漳");  // Generated
		cLabel.setFont(new Font(Display.getDefault(), "ü", 11, SWT.BOLD));  // Generated
		cLabel.setBounds(new Rectangle(3, 2, 370, 24));  // Generated	
		
		lblGroup = new Label(sShell, SWT.NONE);
		lblGroup.setText("׷: ");  // Generated
		lblGroup.setBounds(new Rectangle(10, 31, 65, 12));  // Generated
		lblName = new Label(sShell, SWT.NONE);
		lblName.setBounds(new Rectangle(10, 56, 65, 12));  // Generated
		lblName.setText("   : ");  // Generated
		txtNm = new Text(sShell, SWT.BORDER);
		txtNm.setBounds(new Rectangle(80, 54, 145, 20));
		sShell.setLayout(null);  // Generated
		
		lblMethod = new Label(sShell, SWT.NONE);
		lblMethod.setBounds(new Rectangle(10, 83, 63, 14));  // Generated
		lblMethod.setText("   : ");  // Generated
		lblFileNm = new Label(sShell, SWT.NONE);
		lblFileNm.setBounds(new Rectangle(9, 204, 65, 13));  // Generated
		lblFileNm.setText("ϸ: ");  // Generated
		txtFileNm = new Text(sShell, SWT.BORDER);
		txtFileNm.setBounds(new Rectangle(79, 197, 282, 20));  // Generated
		lblDelay = new Label(sShell, SWT.NONE);
		lblDelay.setBounds(new Rectangle(9, 225, 63, 15));  // Generated
		lblDelay.setText("۾ֱ: ");  // Generated
		txtDelay = new Text(sShell, SWT.BORDER);
		txtDelay.setBounds(new Rectangle(79, 222, 122, 20));  // Generated
		lblDelayNm = new Label(sShell, SWT.NONE);
		lblDelayNm.setBounds(new Rectangle(208, 224, 38, 14));  // Generated
		lblDelayNm.setText("");  // Generated	
		txtGroupNm = new Text(sShell, SWT.BORDER);
		txtGroupNm.setBounds(new Rectangle(80, 29, 145, 20));  // Generated
		createGrpFont();
		createGrpFTP();
		createGrpAlarm();
		
		createCbMethod();
		//-------------------------------------------------------------------------------------		
		
		initDisplay();
		
		return sShell;
	}
	
	/**
	 * ȭ  ʱȭŲ.
	 *
	 */
	private void initDisplay() {
		try {
			txtGroupNm.setText(_groupNm);
			txtNm.setText(_entry.getName());
			txtFileNm.setText(_entry.getPath());
	
			// ftp  ߿  ־Ѵ.
			cbMethod.select(new Integer(_entry.getType()).intValue());
			// ftp  ߿  ־Ѵ.		
			
			// ftp  
			txtIP.setText(_entry.getFtpIP());
			txtPort.setText(_entry.getFtpPort());
			txtId.setText(_entry.getFtpID());
			txtPass.setText(_entry.getFtpPass());
			
			txtDelay.setText(""+_entry.getDelaySecond());
			
			// font  
			int intFont = Integer.parseInt(_entry.getFont());		
			cbFont.select(intFont);
			
			int intFontSize = Integer.parseInt(_entry.getFontSize());
			cbFontSize.select(intFontSize);
			
			String arryFontCol[] = StringUtils.split(_entry.getFontcolor(), '|');				
			Color colFont = new Color(parentShell.getDisplay(), 
									Integer.parseInt(arryFontCol[0]), 
									Integer.parseInt(arryFontCol[1]), 
									Integer.parseInt(arryFontCol[2])
						);
			lbFontCol.setBackground(colFont);
			
			String arryBackCol[] = StringUtils.split(_entry.getBackGroundColor(), '|');				
			Color colBack = new Color(parentShell.getDisplay(), 
									Integer.parseInt(arryBackCol[0]), 
									Integer.parseInt(arryBackCol[1]), 
									Integer.parseInt(arryBackCol[2])
						);
			lbBackCol.setBackground(colBack);
			// font   
			
			txtLineMit.setText(_entry.getLineCount());
			txtAlarm.setText(_entry.getAlalrmData());
			
			String arryAlarmCol[] = StringUtils.split(_entry.getAlalrmBackColor(), '|');				
			Color colAlarm = new Color(parentShell.getDisplay(), 
									Integer.parseInt(arryAlarmCol[0]), 
									Integer.parseInt(arryAlarmCol[1]), 
									Integer.parseInt(arryAlarmCol[2])
						);
			lbAlarm.setBackground(colAlarm);
			
			int intAlarmTeyp = Integer.parseInt(_entry.getAlarmType());		
			cbAlarmType.select(intAlarmTeyp);
			
			// StyledText ǥϱ  ڵ --------------------
			Font font = new Font(parentShell.getDisplay(), 
								LogDefine.FONTS[intFont],
								Integer.parseInt(LogDefine.FONT_SIZES[intFontSize]),
								SWT.NORMAL
							);
			
			testStyledTxt.setFont(font);
			testStyledTxt.setForeground(colFont);
			testStyledTxt.setBackground(colBack);
			testStyledTxt.setText("׽Ʈ ޽ Ÿ غ.");
			
			testStyledTxt.addLineBackgroundListener(new LineBackgroundListener() {
				public void lineGetBackground(LineBackgroundEvent event) {
					String[] searchTxt = StringUtils.split(txtAlarm.getText(), ",");
					
					for(int i=0; i<searchTxt.length; i++) {
						if(StringUtils.contains(event.lineText, searchTxt[i])) {
							event.lineBackground = lbAlarm.getBackground();						
						}	
					}									
				}
			});
			// StyledText ǥϱ  ڵ --------------------	
			
			txtIP.setText(_entry.getFtpIP());
			txtPort.setText(_entry.getFtpPort());
			txtId.setText(_entry.getFtpID());
			txtPass.setText(_entry.getFtpPass());
			chkPasMode.setText(_entry.getFtpMode());
			
			// ϰϴ Ű 
//			seq = _entry.getSeq();
		} catch(Exception e) {
			e.printStackTrace();			
		}
	}
	
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, "", true);
		createButton(parent, IDialogConstants.CANCEL_ID, "", false);
	}
	
	/**
	 * This method initializes cbMethod	
	 *
	 */
	private void createCbMethod() {
		cbMethod = new Combo(sShell, SWT.READ_ONLY);
		cbMethod.setBounds(new Rectangle(81, 76, 149, 20));  // Generated
		cbMethod.setEnabled(true);  // Generated
		cbMethod.addModifyListener(new org.eclipse.swt.events.ModifyListener() {
			public void modifyText(org.eclipse.swt.events.ModifyEvent e) {
				int selIndex = cbMethod.getSelectionIndex();
				
				if(selIndex == 3 | selIndex == 4) {
					MessageDialog.openWarning(getShell(), "Ȯ", " File, HTTP, Telnet ĸ   ˴ϴ.");
				
					//  õǵ Ѵ.
					cbMethod.select(0);
				// Telnet, ftp̸ Ҽ ֵ Ѵ.
				} else if(selIndex == 2 | selIndex == 4) {
					txtIP.setEnabled(true);
					txtPort.setEnabled(true);
					txtId.setEnabled(true);
					txtPass.setEnabled(true);
					chkPasMode.setEnabled(true);
				} else {
					txtIP.setEnabled(false);
					txtPort.setEnabled(false);
					txtId.setEnabled(false);
					txtPass.setEnabled(false);
					chkPasMode.setEnabled(false);
				}
				
			}
		});
		
		cbMethod.add("Local File", 0);
		cbMethod.add("HTTP", 1);
		cbMethod.add("Telnet", 2);
		cbMethod.add("Message", 3);
		cbMethod.add("FTP", 4);
		cbMethod.add("DB", 5);
		
		//   ϵ Ѵ.
		cbMethod.select(0);
	}
	
	/**
	 * This method initializes grpAlarm	
	 *
	 */
	private void createGrpAlarm() {
		grpAlarm = new Group(sShell, SWT.SHADOW_ETCHED_OUT);
		grpAlarm.setLayout(null);  // Generated
		grpAlarm.setText("˶ǥ");  // Generated
		grpAlarm.setBounds(new Rectangle(10, 424, 355, 71));  // Generated
		txtAlarm = new Text(grpAlarm, SWT.BORDER);
		txtAlarm.setBounds(new Rectangle(72, 17, 266, 20));  // Generated
		txtAlarm.setToolTipText("˻ϰ   Էϼ.  Է½ ,  Ͻø ˴ϴ.");
		
		createCbAlarmType();
		lbAlarm = new CLabel(grpAlarm, SWT.NONE);
		lbAlarm.setBackground(new Color(Display.getCurrent(), 109, 233, 216));  // Generated
		lbAlarm.setText("");  // Generated
		lbAlarm.setBounds(new Rectangle(126, 44, 52, 20));  // Generated
		btnAlarmCol = new Button(grpAlarm, SWT.PUSH);
		btnAlarmCol.setBounds(new Rectangle(74, 44, 48, 22));  // Generated
		btnAlarmCol.setText("˶");  // Generated
		
		btnAlarmCol.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				ColorDialog dialog = new ColorDialog(parentShell);
				RGB rgb = dialog.open();
				
				if(rgb != null) {
					Color col = new Color(parentShell.getDisplay(), rgb);
					lbAlarm.setBackground(col);
				}
			}
		});
	}
	
	/**
	 * This method initializes cbAlarmType	
	 *
	 */
	private void createCbAlarmType() {
		cbAlarmType = new Combo(grpAlarm, SWT.READ_ONLY);
		cbAlarmType.setBounds(new Rectangle(252, 45, 85, 20));  // Generated
		
		for(int i=0; i<LogDefine.ALARM_TYPE.length; i++) {
			cbAlarmType.add(LogDefine.ALARM_TYPE[i]);
		}
		
		cbAlarmType.select(0);
	}

	protected void okPressed() {						
		//׷, ̸ ߺǾ ˻Ѵ.
//		GetLogInfo info = new GetLogInfo();
//		LogViewerEntry entry = info.getLogViewerEntry(strGroupNm, strTxtNm);
//		if(entry != null) {
//			MessageDialog.openError(getShell(), "ߺ", "׷  [" + strGroupNm + "] ̸  [" + strTxtNm + "] ߺ Ǿ ϴ. \r\n Ȯ ֽʽÿ.");
//			
//			return;
//		}
		
//		if("".equals(getTxtGroupNm())) {
//			MessageDialog.openError(getShell(), "Ȯ", "׷ ʼԴϴ.");
//			
//			return;
//		}
		
		System.out.println("[alarmType]" + cbMethod.getSelectionIndex());
		
		// telnet 츦 ߰Ѵ.
		if(LogDefine.TELNET_TYPE.equals(""+cbMethod.getSelectionIndex())) {
			if("".equals(txtIP.getText())) {
				MessageDialog.openError(getShell(), "Ȯ", "IP ʼԴϴ.");
				
				return;
			}
			
			if("".equals(txtPort.getText())) {
				MessageDialog.openError(getShell(), "Ȯ", "Port ʼԴϴ.");
				
				return;
			}
			
			if("".equals(txtId.getText())) {
				MessageDialog.openError(getShell(), "Ȯ", "ID ʼԴϴ.");
				
				return;
			}
			
			if("".equals(txtPass.getText())) {
				MessageDialog.openError(getShell(), "Ȯ", "Pass ʼԴϴ.");
				
				return;
			}		
			
			_entry.setFtpIP(txtIP.getText());
			_entry.setFtpPort(txtPort.getText());
			_entry.setFtpID(txtId.getText());
			_entry.setFtpPass(txtPass.getText());
			_entry.setFtpMode(chkPasMode.getText());
		}
		
		if("".equals(txtNm.getText())) {
			MessageDialog.openError(getShell(), "Ȯ", "̸ ʼԴϴ.");
			
			return;
		}
		
		if("".equals(txtFileNm.getText())) {
			MessageDialog.openError(getShell(), "Ȯ", "ϸ ʼԴϴ.");
			
			return;
		}		
				
		if("".equals(txtDelay.getText())) {
			MessageDialog.openError(getShell(), "Ȯ", "۾ ֱ⸦ ʼԴϴ.");
			
			return;
		}
	
		try {
			new Integer(txtDelay.getText()).intValue();
		} catch (NumberFormatException nfe) {
			MessageDialog.openError(getShell(), "Ȯ", "۾ ֱ  ̾ մϴ.");
			
			return;
		}
		
		try {
			new Integer(txtLineMit.getText()).intValue();
		} catch (NumberFormatException nfe) {
			MessageDialog.openError(getShell(), "Ȯ", "ʱȭ   ̾ մϴ.");
			
			return;
		}
		
		// dao Ѵ.
		_entry.setName(txtNm.getText());
		_entry.setType(""+cbMethod.getSelectionIndex());
		_entry.setPath(txtFileNm.getText());
		_entry.setDelaySecond(Long.parseLong(txtDelay.getText()));
		_entry.setFont(""+cbFont.getSelectionIndex());
		_entry.setFontSize(""+cbFontSize.getSelectionIndex());
		
		Color _FontCol 	= lbFontCol.getBackground();		
		_entry.setFontcolor(_FontCol.getRed() + "|" + _FontCol.getGreen() + "|"+ _FontCol.getBlue() + "|");
		
		Color _backtCol = lbBackCol.getBackground();
		_entry.setBackGroundColor(_backtCol.getRed() + "|" + _backtCol.getGreen() + "|"+ _backtCol.getBlue() + "|");
		
		_entry.setLineCount(txtLineMit.getText());
		_entry.setAlalrmData(txtAlarm.getText());
		
		Color _alarmCol = lbAlarm.getBackground();
		_entry.setAlalrmBackColor(_alarmCol.getRed() + "|" + _alarmCol.getGreen() + "|"+ _alarmCol.getBlue() + "|");
		
		_entry.setAlarmType(""+cbAlarmType.getSelectionIndex());
		
		super.okPressed();
	}
	
	/**
	 * This method initializes grpFont	
	 *
	 */
	private void createGrpFont() {
		grpFont = new Group(sShell, SWT.SHADOW_ETCHED_OUT);
		grpFont.setLayout(null);
		grpFont.setText("Ÿ");		
		grpFont.setBounds(new Rectangle(9, 255, 354, 162));
		lblFont = new Label(grpFont, SWT.NONE);
		lblFont.setBounds(new Rectangle(8, 24, 61, 21));
		lblFont.setText("  Ʈ: ");
		createCbFont();
		createCbFontSize();
		
		btnFontCol = new Button(grpFont, SWT.UP | SWT.PUSH);
		btnFontCol.setBounds(new Rectangle(219, 24, 67, 22));  // Generated
		btnFontCol.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_DARK_GREEN));  // Generated
		btnFontCol.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_INFO_BACKGROUND));  // Generated		
		btnFontCol.setText("Ʈ");  // Generated
		
		lbFontCol = new CLabel(grpFont, SWT.NONE);
		lbFontCol.setText("");  // Generated
		lbFontCol.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_BLACK));  // Generated
		lbFontCol.setBounds(new Rectangle(217, 19, 72, 32));  // Generated
				
		btnFontCol.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				ColorDialog dialog = new ColorDialog(parentShell);
				RGB rgb = dialog.open();
				
				if(rgb != null) {
					Color col = new Color(parentShell.getDisplay(), rgb);
					lbFontCol.setBackground(col);	
					
					// testStyledTxt ش.
					testStyledTxt.setForeground(col);
				}
			}
		});
		btnBackCol = new Button(grpFont, SWT.PUSH);
		btnBackCol.setBounds(new Rectangle(75, 56, 68, 22));  // Generated
		btnBackCol.setText("");  // Generated
		
		lbBackCol = new CLabel(grpFont, SWT.NONE);
		lbBackCol.setText("");  // Generated
		lbBackCol.setForeground(new Color(Display.getCurrent(), 109, 233, 216));  // Generated
		lbBackCol.setBounds(new Rectangle(71, 51, 76, 30));  // Generated
		
		btnBackCol.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				ColorDialog dialog = new ColorDialog(parentShell);
				RGB rgb = dialog.open();
				
				if(rgb != null) {
					Color col = new Color(parentShell.getDisplay(), rgb);
					lbBackCol.setBackground(col);
					
					testStyledTxt.setBackground(col);
				}
			}
		});
		
		testStyledTxt = new StyledText(grpFont, SWT.NONE);
		testStyledTxt.setBounds(new Rectangle(73, 89, 274, 59));  // Generated
		
		txtLineMit = new Text(grpFont, SWT.BORDER);
		txtLineMit.setBounds(new Rectangle(276, 58, 74, 20));  // Generated
		lblLineLimit = new Label(grpFont, SWT.NONE);
		lblLineLimit.setBounds(new Rectangle(213, 62, 60, 21));  // Generated
		lblLineLimit.setText("ʱȭ");  // Generated		
	}

	/**
	 * This method initializes cbFont	
	 *
	 */
	private void createCbFont() {
		cbFont = new Combo(grpFont, SWT.READ_ONLY);
		cbFont.setBounds(new Rectangle(72, 24, 71, 20));
		cbFont.addModifyListener(new org.eclipse.swt.events.ModifyListener() {
			public void modifyText(org.eclipse.swt.events.ModifyEvent e) {
				changeFont();
			}
		});
		
		for (int i = 0; i < LogDefine.FONTS.length; i++) {
			cbFont.add(LogDefine.FONTS[i]);
		}
		
		cbFont.select(0);
	}

	/**
	 * Ʈ Ǿ StyledText  ش.
	 */
	private void changeFont() {
		try {
			Font font = new Font(parentShell.getDisplay(), 
								LogDefine.FONTS[cbFont.getSelectionIndex()],
								Integer.parseInt(cbFontSize.getText()),
								0
							);
			
			testStyledTxt.setFont(font);
		} catch(Exception e) {
//			ȭ ó ׷  Ʈ .
//			e.printStackTrace();			
		}
	}

	/**
	 * This method initializes cbFontSize	
	 *
	 */
	private void createCbFontSize() {
		cbFontSize = new Combo(grpFont, SWT.READ_ONLY);
		cbFontSize.setBounds(new Rectangle(146, 24, 70, 20));
		cbFontSize.addModifyListener(new org.eclipse.swt.events.ModifyListener() {
			public void modifyText(org.eclipse.swt.events.ModifyEvent e) {
				changeFont();
			}
		});
		
		for (int i = 0; i < LogDefine.FONT_SIZES.length; i++) {
			cbFontSize.add(LogDefine.FONT_SIZES[i]);
		}
		
		cbFontSize.select(0);
	}	

	/**
	 * This method initializes grpFTP	
	 *
	 */
	private void createGrpFTP() {
		grpFTP = new Group(sShell, SWT.NONE);
		grpFTP.setLayout(null);
		grpFTP.setBounds(new Rectangle(83, 102, 278, 87));
		grpFTP.setBounds(new Rectangle(83, 105, 278, 87));
		lblIP = new Label(grpFTP, SWT.NONE);
		lblIP.setBounds(new Rectangle(10, 16, 57, 15));
		lblIP.setText("IP/Port: ");
		lblID = new Label(grpFTP, SWT.NONE);
		lblID.setBounds(new Rectangle(8, 39, 56, 18));
		lblID.setText("ID/Pass: ");
		lblPass = new Label(grpFTP, SWT.NONE);
		lblPass.setBounds(new Rectangle(8, 65, 95, 18));
		lblPass.setText("Passve Mode: ");
		txtIP = new Text(grpFTP, SWT.BORDER);
		txtIP.setBounds(new Rectangle(68, 13, 99, 22));
		txtIP.setEnabled(false);
		txtPort = new Text(grpFTP, SWT.BORDER);
		txtPort.setBounds(new Rectangle(170, 13, 36, 21));
		txtPort.setEnabled(false);
		txtPort.setText("23");
		
		txtId = new Text(grpFTP, SWT.BORDER);
		txtId.setBounds(new Rectangle(68, 38, 100, 21));
		txtId.setEnabled(false);
		txtPass = new Text(grpFTP, SWT.BORDER | SWT.PASSWORD);
		txtPass.setBounds(new Rectangle(170, 38, 97, 21));
		txtPass.setEnabled(false);
		chkPasMode = new Button(grpFTP, SWT.CHECK);
		chkPasMode.setBounds(new Rectangle(108, 65, 22, 21));
		chkPasMode.setEnabled(false);
	}

	public LogViewerEntry get_entry() {
		return _entry;
	}

//	public long getSeq() {
//		return seq;
//	}
//	public Combo getCbMethod() {
//		return cbMethod;
//	}

	
}  //  @jve:decl-index=0:visual-constraint="10,10,379,214"
